# ------------------------------------------------------------
# Author: Natalie Romanov
# ------------------------------------------------------------

class supp_figure4a:
	@staticmethod
	def execute(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		print('SUPP-FIGURE4A: main_supp_figure4a_go_histograms')
		supp_figure4a.main_supp_figure3a_go_histograms(folder = folder, output_folder = output_folder)

	@staticmethod
	def main_supp_figure4a_go_histograms(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		print('plot_BP_go_output')
		supp_figure4a.plot_BP_go_output(folder  = folder, output_folder = output_folder)

		print('plot_CC_go_output')
		supp_figure4a.plot_CC_go_output(folder  = folder, output_folder = output_folder)

	@staticmethod
	def plot_BP_go_output(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		fdr_data = DataFrameAnalyzer.open_in_chunks(folder,'BP_go_output_fdrData_male_female_difference_DAVID6_8.tsv.gz')
		fe_data = DataFrameAnalyzer.open_in_chunks(folder,'BP_go_output_feData_male_female_difference_DAVID6_8.tsv.gz')
		size_data = DataFrameAnalyzer.open_in_chunks(folder,'BP_go_output_sizeData_male_female_difference_DAVID6_8.tsv.gz')
		fdr_data = fdr_data.T
		fe_data = fe_data.T
		size_data = size_data.T

		quant_fdr_data = fdr_data[['mq','fq']]
		quant_fdr_data = quant_fdr_data.dropna(thresh=1)
		stoch_fdr_data = fdr_data[['ms','fs']]
		stoch_fdr_data = stoch_fdr_data.dropna(thresh=1)
		quant_size_data = size_data[['mq','fq']]
		quant_size_data = quant_size_data.dropna(thresh=1)
		stoch_size_data = size_data[['ms','fs']]
		stoch_size_data = stoch_size_data.dropna(thresh=1)
		quant_fe_data = fe_data[['mq','fq']]
		quant_fe_data = quant_fe_data.dropna(thresh=1)
		stoch_fe_data = fe_data[['ms','fs']]
		stoch_fe_data = stoch_fe_data.dropna(thresh=1)

		quant_fe_data = quant_fe_data.replace(np.nan, 0)
		stoch_fe_data = stoch_fe_data.replace(np.nan,0)
		quant_fdr_data = quant_fdr_data.replace(np.nan, 0)
		stoch_fdr_data = stoch_fdr_data.replace(np.nan,0)

		quant_fe_data = quant_fe_data.sort_values('mq', ascending = False)
		q1 = quant_fe_data[quant_fe_data.mq>0]
		q2 = quant_fe_data[quant_fe_data.mq<=0]
		q2 = q2.sort_values('fq')
		quant_fe_data = pd.concat([q1,q2])

		stoch_fe_data = stoch_fe_data.sort_values('ms', ascending = False)
		q1 = stoch_fe_data[stoch_fe_data.ms>0]
		q2 = stoch_fe_data[stoch_fe_data.ms<=0]
		q2 = q2.sort_values('fs')
		stoch_fe_data = pd.concat([q1,q2])

		stoch_fdr_data = stoch_fdr_data.T[list(stoch_fe_data.index)].T
		quant_fdr_data = quant_fdr_data.T[list(quant_fe_data.index)].T

		import matplotlib.colors as mcolors
		c = mcolors.ColorConverter().to_rgb
		male_seq = [c('pink'),c('pink'),c('magenta'),c('magenta'),c('purple'),c('purple')]
		female_seq = [c('lightgreen'),c('lightgreen'), c('green'),c('green'), c('darkgreen'),c('darkgreen')]
		male_my_cmap = colorFacade.make_colormap(male_seq, 'male')
		female_my_cmap = colorFacade.make_colormap(female_seq, 'female')

		male_quant_fe_list = list(quant_fe_data.mq)
		female_quant_fe_list = list(quant_fe_data.fq)
		quant_label_list = [item.split('~')[1] for item in list(quant_fe_data.index)]
		sc, quant_male_color_list = colorFacade.get_specific_color_gradient(male_my_cmap, np.array(quant_fe_data.mq))
		sc, quant_female_color_list = colorFacade.get_specific_color_gradient(female_my_cmap, np.array(quant_fe_data.fq))
		male_stoch_fe_list = list(stoch_fe_data.ms)
		female_stoch_fe_list = list(stoch_fe_data.fs)
		stoch_label_list = [item.split('~')[1] for item in list(stoch_fe_data.index)]
		sc, stoch_male_color_list = colorFacade.get_specific_color_gradient(male_my_cmap, np.array(stoch_fe_data.ms))
		sc, stoch_female_color_list = colorFacade.get_specific_color_gradient(female_my_cmap, np.array(stoch_fe_data.fs))
		
		quant_ind = np.arange(len(quant_fe_data))
		stoch_ind = np.arange(len(stoch_fe_data))

		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (7,5))
		ax = fig.add_subplot(111)
		width = 0.85
		colors = [sc.to_rgba(item) for item in male_stoch_fe_list]
		rects = ax.bar(stoch_ind, male_stoch_fe_list, width, color = stoch_male_color_list, edgecolor = 'white')
		rects = ax.bar(stoch_ind, (-1)*np.array(female_stoch_fe_list), width, color = stoch_female_color_list, edgecolor = 'white')
		ax.set_xlim(0,len(stoch_ind))
		plt.xticks(list(utilsFacade.frange(0.5,len(stoch_label_list)+0.5,1)))
		ax.set_xticklabels(stoch_label_list, rotation = 90)
		plt.savefig(output_folder + 'suppFig4a_BP_stoichiometry_male_female_barplot_DAVID6_8.pdf',
					bbox_inches = 'tight', dpi = 300)

	@staticmethod
	def plot_CC_go_output(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		fdr_data = DataFrameAnalyzer.open_in_chunks(folder,'CC_go_output_fdrData_male_female_difference_DAVID6_8.tsv.gz')
		fe_data = DataFrameAnalyzer.open_in_chunks(folder,'CC_go_output_feData_male_female_difference_DAVID6_8.tsv.gz')
		size_data = DataFrameAnalyzer.open_in_chunks(folder,'CC_go_output_sizeData_male_female_difference_DAVID6_8.tsv.gz')
		fdr_data = fdr_data.T
		fe_data = fe_data.T
		size_data = size_data.T

		quant_fdr_data = fdr_data[['mq','fq']]
		quant_fdr_data = quant_fdr_data.dropna(thresh=1)
		stoch_fdr_data = fdr_data[['ms','fs']]
		stoch_fdr_data = stoch_fdr_data.dropna(thresh=1)
		quant_size_data = size_data[['mq','fq']]
		quant_size_data = quant_size_data.dropna(thresh=1)
		stoch_size_data = size_data[['ms','fs']]
		stoch_size_data = stoch_size_data.dropna(thresh=1)
		quant_fe_data = fe_data[['mq','fq']]
		quant_fe_data = quant_fe_data.dropna(thresh=1)
		stoch_fe_data = fe_data[['ms','fs']]
		stoch_fe_data = stoch_fe_data.dropna(thresh=1)

		quant_fe_data = quant_fe_data.replace(np.nan, 0)
		stoch_fe_data = stoch_fe_data.replace(np.nan,0)
		quant_fdr_data = quant_fdr_data.replace(np.nan, 0)
		stoch_fdr_data = stoch_fdr_data.replace(np.nan,0)

		quant_fe_data = quant_fe_data.sort_values('mq', ascending = False)
		q1 = quant_fe_data[quant_fe_data.mq>0]
		q2 = quant_fe_data[quant_fe_data.mq<=0]
		q2 = q2.sort_values('fq')
		quant_fe_data = pd.concat([q1,q2])

		stoch_fe_data = stoch_fe_data.sort_values('ms', ascending = False)
		q1 = stoch_fe_data[stoch_fe_data.ms>0]
		q2 = stoch_fe_data[stoch_fe_data.ms<=0]
		q2 = q2.sort_values('fs')
		stoch_fe_data = pd.concat([q1,q2])

		stoch_fdr_data = stoch_fdr_data.T[list(stoch_fe_data.index)].T
		quant_fdr_data = quant_fdr_data.T[list(quant_fe_data.index)].T

		import matplotlib.colors as mcolors
		c = mcolors.ColorConverter().to_rgb
		male_seq = [c('pink'),c('pink'),c('magenta'),c('magenta'),c('purple'),c('purple')]
		female_seq = [c('lightgreen'),c('lightgreen'), c('green'),c('green'), c('darkgreen'),c('darkgreen')]
		male_my_cmap = colorFacade.make_colormap(male_seq, 'male')
		female_my_cmap = colorFacade.make_colormap(female_seq,'female')

		male_quant_fe_list = list(quant_fe_data.mq)
		female_quant_fe_list = list(quant_fe_data.fq)
		quant_label_list = [item.split('~')[1] for item in list(quant_fe_data.index)]
		sc, quant_male_color_list = colorFacade.get_specific_color_gradient(male_my_cmap, np.array(quant_fe_data.mq))
		sc, quant_female_color_list = colorFacade.get_specific_color_gradient(female_my_cmap, np.array(quant_fe_data.fq))
		male_stoch_fe_list = list(stoch_fe_data.ms)
		female_stoch_fe_list = list(stoch_fe_data.fs)
		stoch_label_list = [item.split('~')[1] for item in list(stoch_fe_data.index)]
		sc, stoch_male_color_list = colorFacade.get_specific_color_gradient(male_my_cmap, np.array(stoch_fe_data.ms))
		sc, stoch_female_color_list = colorFacade.get_specific_color_gradient(female_my_cmap, np.array(stoch_fe_data.fs))
		
		quant_ind = np.arange(len(quant_fe_data))
		stoch_ind = np.arange(len(stoch_fe_data))


		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (15,5))
		ax = fig.add_subplot(111)

		width = 0.85
		colors = [sc.to_rgba(item) for item in male_quant_fe_list]
		rects = ax.bar(quant_ind, male_quant_fe_list, width, color = quant_male_color_list, edgecolor = 'white')
		rects = ax.bar(quant_ind, (-1)*np.array(female_quant_fe_list), width, color = quant_female_color_list, edgecolor = 'white')
		ax.set_xlim(0,len(quant_ind))
		plt.xticks(list(utilsFacade.frange(0.5,len(quant_label_list)+0.5,1)))
		ax.set_xticklabels(quant_label_list, rotation = 90)
		plt.savefig(folder + 'CC_abundances_male_female_barplot_DAVID6_8.pdf', bbox_inches = 'tight', dpi = 300)

		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (7,5))
		ax = fig.add_subplot(111)
		width = 0.85
		colors = [sc.to_rgba(item) for item in male_stoch_fe_list]
		rects = ax.bar(stoch_ind, male_stoch_fe_list, width, color = stoch_male_color_list, edgecolor = 'white')
		rects = ax.bar(stoch_ind, (-1)*np.array(female_stoch_fe_list), width, color = stoch_female_color_list, edgecolor = 'white')
		ax.set_xlim(0,len(stoch_ind))
		plt.xticks(list(utilsFacade.frange(0.5,len(stoch_label_list)+0.5,1)))
		ax.set_xticklabels(stoch_label_list, rotation = 90)
		plt.savefig(output_folder + 'suppFig4a_CC_stoichiometry_male_female_barplot_DAVID6_8.pdf',
					bbox_inches = 'tight', dpi = 300)

class supp_figure4b:
	@staticmethod
	def execute(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		print('SUPP-FIGURE4B: supp_figure4b_complex_scatter_abundances')
		supp_figure4b.main_figure4b_complex_scatter_abundances(folder = folder, output_folder = output_folder)

		print('SUPP-FIGURE4B: supp_figure4b_subunit_scatter_abundances')
		supp_figure4b.main_figure4b_subunit_scatter_abundances(folder = folder, output_folder = output_folder)

	@staticmethod
	def main_figure4b_complex_scatter_abundances(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		df = DataFrameAnalyzer.open_in_chunks(folder,'fig5d_gygi3_complex_total_abundance_difference.tsv.gz')
		sex_cohen_list = list(df['sex'])
		diet_cohen_list = list(df['diet'])
		colors = list(df['color'])

		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (5,5))
		ax = fig.add_subplot(111)
		ax.scatter(sex_cohen_list, diet_cohen_list, edgecolor = 'black',
		 	color = colors, alpha = 0.7, s = 80)
		plottingFacade.add_trendline(ax, sex_cohen_list, diet_cohen_list, color = 'k')
		ax.set_title(scipy.stats.pearsonr(sex_cohen_list, diet_cohen_list))
		ax.set_xlabel('sex')
		ax.set_ylabel('diet')
		ax.set_xlim(-2,2)
		ax.set_ylim(-2,2)
		plt.savefig(folder + 'suppFig4b_complex_abundance_comparing_diet_sex.pdf',
					bbox_inches = 'tight', dpi = 400)

	@staticmethod
	def main_figure4b_subunit_scatter_abundances(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		df = DataFrameAnalyzer.open_in_chunks(folder, 'data/fig5d_gygi3_subunit_stoichiometry_difference.tsv.gz')
		gender_stoch_list = df['gender']
		diet_stoch_list = df['diet']
		colors = df['color']

		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (7,7))
		ax = fig.add_subplot(111)
		ax.scatter(np.array(gender_stoch_list), np.array(diet_stoch_list),
				   color = colors, edgecolor = 'black', alpha = 0.7, s = 30)
		plottingFacade.add_trendline(ax,np.array(gender_stoch_list),
									 np.array(diet_stoch_list), color = 'k')
		ax.set_xlim(-1,1)
		ax.set_ylim(-1,1)
		ax.set_title(scipy.stats.pearsonr(np.array(gender_stoch_list), np.array(diet_stoch_list)))
		ax.set_xlabel('logFC (male/female)')
		ax.set_ylabel('logFC (high-fat/chow)')
		plt.savefig(folder + 'suppFig4b_logFC_complexSubunits_scatter_stoichiometry_gender_diet.pdf',
					bbox_inches	= 'tight', dpi = 400)

class supp_figure4c:
	@staticmethod
	def execute(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		print('SUPP-FIGURE4C: main_supp_figure4c_volcanoPlots')
		supp_figure4c.main_supp_figure4c_volcanoPlots(folder = folder, output_folder = output_folder)

	@staticmethod
	def main_supp_figure4c_volcanoPlots(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		print('SUPP-FIGURE3C: suppFigure4c_volcanoPlot_cop1_hsComparison')
		supp_figure4c.suppFigure4c_volcanoPlot_cop1_hsComparison(folder = folder, output_folder = output_folder)
		print('SUPP-FIGURE3C: suppFigure4c_volcanoPlot_cop2_hsComparison')
		supp_figure4c.suppFigure4c_volcanoPlot_cop2_hsComparison(folder = folder, output_folder = output_folder)
		print('SUPP-FIGURE3C: suppFigure4c_volcanoPlot_cohesin_hsComparison')
		supp_figure4c.suppFigure4c_volcanoPlot_cohesin_hsComparison(folder = folder, output_folder = output_folder)
		print('SUPP-FIGURE3C: suppFigure4c_volcanoPlot_retromer_hsComparison')
		supp_figure4c.suppFigure4c_volcanoPlot_retromer_hsComparison(folder = folder, output_folder = output_folder)

	@staticmethod
	def main_supp_figure4c_boxPlots(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		print('SUPP-FIGURE3C: suppFigure4c_cop1_boxplot_logFC_hsComparison')
		supp_figure4c.suppFigure4c_cop1_boxplot_logFC_hsComparison(folder = folder, output_folder = output_folder)
		print('SUPP-FIGURE3C: suppFigure4c_cop2_boxplot_logFC_hsComparison')
		supp_figure4c.suppFigure4c_cop2_boxplot_logFC_hsComparison(folder = folder, output_folder = output_folder)
		print('SUPP-FIGURE3C: suppFigure4c_retromer_boxplot_logFC_hsComparison')
		supp_figure4c.suppFigure4c_retromer_boxplot_logFC_hsComparison(folder = folder, output_folder = output_folder)
		print('SUPP-FIGURE3C: suppFigure4c_cohesin_boxplot_logFC_hsComparison')
		supp_figure4c.suppFigure4c_cohesin_boxplot_logFC_hsComparison(folder = folder, output_folder = output_folder)

	@staticmethod
	def suppFigure4c_volcanoPlot_cop1_hsComparison(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		filename = 'gygi3_complex_hs_merged_perGeneRun.tsv.gz'
		data = DataFrameAnalyzer.open_in_chunks(folder, filename)
		data = data.drop_duplicates()
		data = data[data.analysis_type=='stoch_highfat-chow']
		data = data.drop(['C9','C2','Psd3'], axis = 0)
		complex_data = data[data.complex_search=='HC2402:COPI']

		pval_list = -np.log10(np.array(data['pval.adj']))
		fc_list = np.array(data['logFC'])

		complex_pval_list = -np.log10(np.array(complex_data['pval.adj']))
		complex_fc_list = np.array(complex_data['logFC'])
		complex_label_list = list(complex_data.index)
		complex_colors = ['red' if item<=0.01 else 'darkblue' for item in list(complex_data['pval.adj'])]

		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (5,5))
		ax = fig.add_subplot(111)
		ax.scatter(fc_list, pval_list, edgecolor = 'black', s = 30, color = 'white', alpha = 0.2)
		ax.scatter(complex_fc_list, complex_pval_list, edgecolor = 'black', s = 50, color = complex_colors)
		for count, label in enumerate(complex_label_list):
			x,y = complex_fc_list[count], complex_pval_list[count]
			ax.annotate(label, xy = (x,y), color = complex_colors[count])
		ax.set_xlabel('logFC (male/female)')
		ax.set_ylabel('p.value[-log10]')
		ax.set_xlim(-1.25,1.25)
		ax.set_ylim(-0.01, 10)
		plt.savefig(folder + 'suppFig4c_cop1_volcano_hs_comparison.pdf', bbox_inches = 'tight', dpi = 400)

	@staticmethod
	def suppFigure4c_volcanoPlot_retromer_hsComparison(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		filename = 'gygi3_complex_hs_merged_perGeneRun.tsv.gz'
		data = DataFrameAnalyzer.open_in_chunks(folder, filename)
		data = data.drop_duplicates()
		data = data[data.analysis_type=='stoch_highfat-chow']
		data = data.drop(['C9','C2','Psd3'], axis = 0)
		complex_data = data[data.complex_search.str.contains('retromer')]

		pval_list = -np.log10(np.array(data['pval.adj']))
		fc_list = np.array(data['logFC'])

		complex_pval_list = -np.log10(np.array(complex_data['pval.adj']))
		complex_fc_list = np.array(complex_data['logFC'])
		complex_label_list = list(complex_data.index)
		complex_colors = ['red' if item<=0.01 else 'darkblue' for item in list(complex_data['pval.adj'])]


		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (5,5))
		ax = fig.add_subplot(111)
		ax.scatter(fc_list, pval_list, edgecolor = 'black',s = 30, color = 'white', alpha = 0.2)
		ax.scatter(complex_fc_list, complex_pval_list,edgecolor = 'black', s = 50, color = complex_colors)
		for count, label in enumerate(complex_label_list):
			x,y = complex_fc_list[count], complex_pval_list[count]
			ax.annotate(label, xy = (x,y), color = complex_colors[count])
		ax.set_xlabel('logFC (highfat/chow)')
		ax.set_ylabel('p.value[-log10]')
		ax.set_xlim(-1.25,1.25)
		ax.set_ylim(-0.01, 10)
		plt.savefig(folder + 'suppFig4c_retromer_volcano_hs_comparison.pdf',bbox_inches = 'tight', dpi = 400)

	@staticmethod
	def suppFigure4c_volcanoPlot_cohesin_hsComparison(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		filename = 'gygi3_complex_hs_merged_perGeneRun.tsv.gz'
		data = DataFrameAnalyzer.open_in_chunks(folder, filename)
		data = data.drop_duplicates()
		data = data[data.analysis_type=='stoch_highfat-chow']
		data = data.drop(['C9','C2','Psd3'], axis = 0)
		complex_data = data[data.complex_search.str.contains('Cohesin')]

		pval_list = -np.log10(np.array(data['pval.adj']))
		fc_list = np.array(data['logFC'])

		complex_pval_list = -np.log10(np.array(complex_data['pval.adj']))
		complex_fc_list = np.array(complex_data['logFC'])
		complex_label_list = list(complex_data.index)
		complex_colors = ['red' if item<=0.01 else 'darkblue' for item in list(complex_data['pval.adj'])]


		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (5,5))
		ax = fig.add_subplot(111)
		ax.scatter(fc_list, pval_list, edgecolor = 'black',s = 30, color = 'white', alpha = 0.2)
		ax.scatter(complex_fc_list, complex_pval_list,edgecolor = 'black', s = 50, color = complex_colors)
		for count, label in enumerate(complex_label_list):
			x,y = complex_fc_list[count], complex_pval_list[count]
			ax.annotate(label, xy = (x,y), color = complex_colors[count])
		ax.set_xlabel('logFC (highfat/chow)')
		ax.set_ylabel('p.value[-log10]')
		ax.set_xlim(-1.25,1.25)
		ax.set_ylim(-0.01,10)
		plt.savefig(folder + 'suppFig4c_cohesin_volcano_hs_comparison.pdf',bbox_inches = 'tight', dpi = 400)

	@staticmethod
	def suppFigure4c_volcanoPlot_cop2_hsComparison(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		filename = 'gygi3_complex_hs_merged_perGeneRun.tsv.gz'
		data = DataFrameAnalyzer.open_in_chunks(folder, filename)
		data = data.drop_duplicates()
		data = data[data.analysis_type=='stoch_highfat-chow']
		data = data.drop(['C9','C2','Psd3'], axis = 0)
		complex_data = data[data.complex_search=='HC663:COPII']

		pval_list = -np.log10(np.array(data['pval.adj']))
		fc_list = np.array(data['logFC'])

		complex_pval_list = -np.log10(np.array(complex_data['pval.adj']))
		complex_fc_list = np.array(complex_data['logFC'])
		complex_label_list = list(complex_data.index)
		complex_colors = ['red' if item<=0.01 else 'darkblue' for item in list(complex_data['pval.adj'])]


		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (5,5))
		ax = fig.add_subplot(111)
		ax.scatter(fc_list, pval_list, edgecolor = 'black',s = 30, color = 'white', alpha = 0.2)
		ax.scatter(complex_fc_list, complex_pval_list,edgecolor = 'black', s = 50, color = complex_colors)
		for count, label in enumerate(complex_label_list):
			x,y = complex_fc_list[count], complex_pval_list[count]
			ax.annotate(label, xy = (x,y), color = complex_colors[count])
		ax.set_xlabel('logFC (highfat/chow)')
		ax.set_ylabel('p.value[-log10]')
		ax.set_xlim(-1.25,1.25)
		ax.set_ylim(-0.01, 10)
		plt.savefig(folder + 'suppFig4c_cop2_volcano_hs_comparison.pdf',bbox_inches = 'tight', dpi = 400)
	
	@staticmethod
	def suppFigure4c_cop1_boxplot_logFC_hsComparison(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		filename = 'gygi3_complex_hs_merged_perGeneRun.tsv.gz'
		data = DataFrameAnalyzer.open_in_chunks(folder, filename)
		data = data.drop_duplicates()
		data = data.drop(['C9','C2','Psd3'], axis = 0)
		complex_data = data[data.complex_search=='HC2402:COPI']
		male_data = complex_data[complex_data.analysis_type=='highfat']
		female_data = complex_data[complex_data.analysis_type=='chow']
		stoch_maleFemale_data = complex_data[complex_data.analysis_type=='stoch_highfat-chow']
		pval_dict = stoch_maleFemale_data['pval.adj'].to_dict()

		wpc_data = wp.stoch_gygi3.copy()
		wpc_data = wpc_data[wpc_data.complex_search=='HC2402:COPI']
		quant_list = utilsFacade.filtering(list(wpc_data.columns),'quant_')
		male_list = utilsFacade.filtering(quant_list, 'H')
		female_list = utilsFacade.filtering(quant_list, 'S')
		male_data = wpc_data[male_list].T
		female_data = wpc_data[female_list].T

		protein_list = list(set(male_data.columns).intersection(set(female_data.columns)))
		pval_list = [pval_dict[protein] for protein in protein_list]
		pval_list, protein_list = zip(*sorted(zip(pval_list, protein_list)))
		data_list = list()
		color_list = list()
		sig_protein_list = list()
		positions = [0.5]
		for protein in protein_list:
			if pval_dict[protein]<=0.01:
				data_list.append(utilsFacade.finite(list(male_data[protein])))
				data_list.append(utilsFacade.finite(list(female_data[protein])))
				color_list.append('purple')
				color_list.append('green')
				sig_protein_list.append(protein)
				sig_protein_list.append(protein)
				positions.append(positions[-1]+0.4)
				positions.append(positions[-1]+0.6)

		male_median_data = male_data.T.median().T
		female_median_data = female_data.T.median().T
		data_list.append(list(male_median_data))
		data_list.append(list(female_median_data))
		color_list.append('grey')
		color_list.append('grey')
		sig_protein_list.append('COPI-highfat')
		sig_protein_list.append('COPI-chow')
		positions.append(positions[-1]+0.5)


		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (5,5))
		ax = fig.add_subplot(111)
		bp = ax.boxplot(data_list,notch=0,sym="",vert=1,patch_artist=True,widths=[0.4]*len(data_list), positions = positions)
		plt.setp(bp['medians'], color="black")
		plt.setp(bp['whiskers'], color="black",linestyle="--",alpha=0.8)
		for i,patch in enumerate(bp['boxes']):
			patch.set_edgecolor("black")
			patch.set_alpha(0.6)
			patch.set_color(color_list[i])
			sub_group=data_list[i]
			x = numpy.random.normal(positions[i], 0.04, size=len(data_list[i]))
			ax.scatter(x,sub_group,color='white', alpha=0.5,edgecolor="black",s=5)
		ax.set_title('COPI complex')
		ax.set_xticklabels(sig_protein_list, rotation = 90)
		ax.set_ylim(-1,1)
		ax.set_ylabel('normalized abundances')
		plt.savefig(folder + 'suppFig4c_cop1_boxplot_highfat_chow.pdf',bbox_inches = 'tight', dpi = 400)
	
	@staticmethod
	def suppFigure4c_cop2_boxplot_logFC_hsComparison(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		filename = 'gygi3_complex_hs_merged_perGeneRun.tsv.gz'
		data = DataFrameAnalyzer.open_in_chunks(folder, filename)
		data = data.drop_duplicates()
		data = data.drop(['C9','C2','Psd3'], axis = 0)
		complex_data = data[data.complex_search=='HC663:COPII']
		male_data = complex_data[complex_data.analysis_type=='highfat']
		female_data = complex_data[complex_data.analysis_type=='chow']
		stoch_maleFemale_data = complex_data[complex_data.analysis_type=='stoch_highfat-chow']
		pval_dict = stoch_maleFemale_data['pval.adj'].to_dict()

		wpc_data = wp.stoch_gygi3.copy()
		wpc_data = wpc_data[wpc_data.complex_search=='HC663:COPII']
		quant_list = utilsFacade.filtering(list(wpc_data.columns),'quant_')
		male_list = utilsFacade.filtering(quant_list, 'H')
		female_list = utilsFacade.filtering(quant_list, 'S')
		male_data = wpc_data[male_list].T
		female_data = wpc_data[female_list].T

		protein_list = list(set(male_data.columns).intersection(set(female_data.columns)))
		pval_list = [pval_dict[protein] for protein in protein_list]
		pval_list, protein_list = zip(*sorted(zip(pval_list, protein_list)))
		data_list = list()
		color_list = list()
		sig_protein_list = list()
		positions = [0.5]
		for protein in protein_list:
			if pval_dict[protein]<=0.01:
				data_list.append(utilsFacade.finite(list(male_data[protein])))
				data_list.append(utilsFacade.finite(list(female_data[protein])))
				color_list.append('purple')
				color_list.append('green')
				sig_protein_list.append(protein)
				sig_protein_list.append(protein)
				positions.append(positions[-1]+0.4)
				positions.append(positions[-1]+0.6)

		male_median_data = male_data.T.median().T
		female_median_data = female_data.T.median().T
		data_list.append(list(male_median_data))
		data_list.append(list(female_median_data))
		color_list.append('grey')
		color_list.append('grey')
		sig_protein_list.append('COPII-highfat')
		sig_protein_list.append('COPII-chow')
		positions.append(positions[-1]+0.5)


		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (5,5))
		ax = fig.add_subplot(111)
		bp = ax.boxplot(data_list,notch=0,sym="",vert=1,patch_artist=True,widths=[0.4]*len(data_list), positions = positions)
		plt.setp(bp['medians'], color="black")
		plt.setp(bp['whiskers'], color="black",linestyle="--",alpha=0.8)
		for i,patch in enumerate(bp['boxes']):
			patch.set_edgecolor("black")
			patch.set_alpha(0.6)
			patch.set_color(color_list[i])
			sub_group=data_list[i]
			x = numpy.random.normal(positions[i], 0.04, size=len(data_list[i]))
			ax.scatter(x,sub_group,color='white', alpha=0.5,edgecolor="black",s=5)
		ax.set_title('COPII complex')
		ax.set_xticklabels(sig_protein_list, rotation = 90)
		ax.set_ylim(-1,1)
		ax.set_ylabel('normalized abundances')
		plt.savefig(folder + 'suppFigure4c_cop2_boxplot_highfat_chow.pdf',bbox_inches = 'tight', dpi = 400)

	@staticmethod
	def suppFigure4c_retromer_boxplot_logFC_hsComparison(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		filename = 'gygi3_complex_hs_merged_perGeneRun.tsv.gz'
		data = DataFrameAnalyzer.open_in_chunks(folder, filename)
		data = data.drop_duplicates()
		data = data.drop(['C9','C2','Psd3'], axis = 0)
		complex_data = data[data.complex_search.str.contains('retromer')]
		male_data = complex_data[complex_data.analysis_type=='highfat']
		female_data = complex_data[complex_data.analysis_type=='chow']
		stoch_maleFemale_data = complex_data[complex_data.analysis_type=='stoch_highfat-chow']
		pval_dict = stoch_maleFemale_data['pval.adj'].to_dict()

		wpc_data = wp.stoch_gygi3.copy()
		wpc_data = wpc_data[wpc_data.complex_search.str.contains('MAPK')]
		quant_list = utilsFacade.filtering(list(wpc_data.columns),'quant_')
		male_list = utilsFacade.filtering(quant_list, 'H')
		female_list = utilsFacade.filtering(quant_list, 'S')
		male_data = wpc_data[male_list].T
		female_data = wpc_data[female_list].T

		protein_list = list(set(male_data.columns).intersection(set(female_data.columns)))
		pval_list = [pval_dict[protein] for protein in protein_list]
		pval_list, protein_list = zip(*sorted(zip(pval_list, protein_list)))
		data_list = list()
		color_list = list()
		sig_protein_list = list()
		positions = [0.5]
		for protein in protein_list:
			if pval_dict[protein]<=1:
				data_list.append(utilsFacade.finite(list(male_data[protein])))
				data_list.append(utilsFacade.finite(list(female_data[protein])))
				color_list.append('purple')
				color_list.append('green')
				sig_protein_list.append(protein)
				sig_protein_list.append(protein)
				positions.append(positions[-1]+0.4)
				positions.append(positions[-1]+0.6)

		male_median_data = male_data.T.median().T
		female_median_data = female_data.T.median().T
		data_list.append(list(male_median_data))
		data_list.append(list(female_median_data))
		color_list.append('grey')
		color_list.append('grey')
		sig_protein_list.append('MAPK-highfat')
		sig_protein_list.append('MAPK-chow')
		positions.append(positions[-1]+0.5)

		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (5,5))
		ax = fig.add_subplot(111)
		bp = ax.boxplot(data_list,notch=0,sym="",vert=1,patch_artist=True,widths=[0.4]*len(data_list), positions = positions)
		plt.setp(bp['medians'], color="black")
		plt.setp(bp['whiskers'], color="black",linestyle="--",alpha=0.8)
		for i,patch in enumerate(bp['boxes']):
			patch.set_edgecolor("black")
			patch.set_alpha(0.6)
			patch.set_color(color_list[i])
			sub_group=data_list[i]
			x = numpy.random.normal(positions[i], 0.04, size=len(data_list[i]))
			ax.scatter(x,sub_group,color='white', alpha=0.5,edgecolor="black",s=5)
		ax.set_title('MAPK complex')
		ax.set_xticklabels(sig_protein_list, rotation = 90)
		ax.set_ylim(-1,1)
		ax.set_ylabel('normalized abundances')
		plt.savefig(folder + 'suppFigure4c_retromer_boxplot_highfat_chow.pdf',bbox_inches = 'tight', dpi = 400)

	@staticmethod
	def suppFigure4c_cohesin_boxplot_logFC_hsComparison(**kwargs):
		folder = kwargs.get('folder','PATH')
		output_folder = kwargs.get('output_folder','PATH')

		filename = 'gygi3_complex_hs_merged_perGeneRun.tsv.gz'
		data = DataFrameAnalyzer.open_in_chunks(folder, filename)
		data = data.drop_duplicates()
		data = data.drop(['C9','C2','Psd3'], axis = 0)
		complex_data = data[data.complex_search.str.contains('Cohesin')]
		male_data = complex_data[complex_data.analysis_type=='highfat']
		female_data = complex_data[complex_data.analysis_type=='chow']
		stoch_maleFemale_data = complex_data[complex_data.analysis_type=='stoch_highfat-chow']
		pval_dict = stoch_maleFemale_data['pval.adj'].to_dict()

		wpc_data = wp.stoch_gygi3.copy()
		wpc_data = wpc_data[wpc_data.complex_search.str.contains('Cohesin')]
		quant_list = utilsFacade.filtering(list(wpc_data.columns),'quant_')
		male_list = utilsFacade.filtering(quant_list, 'H')
		female_list = utilsFacade.filtering(quant_list, 'S')
		male_data = wpc_data[male_list].T
		female_data = wpc_data[female_list].T

		protein_list = list(set(male_data.columns).intersection(set(female_data.columns)))
		pval_list = [pval_dict[protein] for protein in protein_list]
		pval_list, protein_list = zip(*sorted(zip(pval_list, protein_list)))
		data_list = list()
		color_list = list()
		sig_protein_list = list()
		positions = [0.5]
		for protein in protein_list:
			if pval_dict[protein]<=1:
				data_list.append(utilsFacade.finite(list(male_data[protein])))
				data_list.append(utilsFacade.finite(list(female_data[protein])))
				color_list.append('purple')
				color_list.append('green')
				sig_protein_list.append(protein)
				sig_protein_list.append(protein)
				positions.append(positions[-1]+0.4)
				positions.append(positions[-1]+0.6)

		male_median_data = male_data.T.median().T
		female_median_data = female_data.T.median().T
		data_list.append(list(male_median_data))
		data_list.append(list(female_median_data))
		color_list.append('grey')
		color_list.append('grey')
		sig_protein_list.append('Cohesin-highfat')
		sig_protein_list.append('Cohesin-chow')
		positions.append(positions[-1]+0.5)

		sns.set(context='notebook', style='white', 
			palette='deep', font='Liberation Sans', font_scale=1, 
			color_codes=False, rc=None)
		plt.rcParams["axes.grid"] = True

		plt.clf()
		fig = plt.figure(figsize = (5,5))
		ax = fig.add_subplot(111)
		bp = ax.boxplot(data_list,notch=0,sym="",vert=1,patch_artist=True,widths=[0.4]*len(data_list), positions = positions)
		plt.setp(bp['medians'], color="black")
		plt.setp(bp['whiskers'], color="black",linestyle="--",alpha=0.8)
		for i,patch in enumerate(bp['boxes']):
			patch.set_edgecolor("black")
			patch.set_alpha(0.6)
			patch.set_color(color_list[i])
			sub_group=data_list[i]
			x = numpy.random.normal(positions[i], 0.04, size=len(data_list[i]))
			ax.scatter(x,sub_group,color='white', alpha=0.5,edgecolor="black",s=5)
		ax.set_title('Cohesin complex')
		ax.set_xticklabels(sig_protein_list, rotation = 90)
		ax.set_ylim(-1,1)
		ax.set_ylabel('normalized abundances')
		plt.savefig(folder + 'suppFig4c_cohesin_boxplot_highfat_chow.pdf',bbox_inches = 'tight', dpi = 400)


if __name__ == "__main__":
	## EXECUTE SUPPFIGURE4
	supp_figure4a.execute(folder = sys.argv[1], output_folder = sys.argv[2])
	supp_figure4b.execute(folder = sys.argv[1], output_folder = sys.argv[2])
	supp_figure4c.execute(folder = sys.argv[1], output_folder = sys.argv[2])
	
