#! /usr/bin/env perl

use strict;
use warnings;
use Pod::Usage;
use Smash::Global qw($SMASH_SCRIPT_NAME);
use Smash::CommandLineParser qw(parse_options check_required_options);
use Smash::Core;
use Smash::Utils::Taxonomy qw(:all);

##############
# Set up command line parsing
##############

my @allowed  = qw(help); # arguments I expect
my @required = ();   # arguments I require

##############
# Parse command line options
##############

my $status;
my $missing;
my %options;

($status, %options) = parse_options(\@allowed);
if ($options{help}) {
	pod2usage(-exitstatus => 0, -verbose => 2);
}
if ($status != 1) {
	pod2usage(-message => "", -exitstatus => 2, -verbose => 1);
}
#print_options(%options);

##############
# Add
##############

my $smash = new Smash::Core();
$smash->init();
$smash->init_smash_environment();
Smash::Utils::Taxonomy::update_files();
$smash->finish();

print "<output>success</output>\n";

exit(0);

=head1 Name

initSmash.pl - Wrapper script to initialize the Smash environment.

=head1 Synopsis

	initSmash.pl [options]

=head1 Options

=over 4

=item B<C<--help>>

Prints this manual.

=back

=head1 Description

B<initSmash.pl> is a wrapper script to initialize the Smash environment. It parses the
Smash config file and initializes the data directory and the databases. Please see
L<"Configure SMASH"|install/"4. Configure SMASH"> section of the installation manual
for the config file specification and where to place it.

=cut
