#!/usr/bin/env perl

# export PERL5LIB=@prefix@/lib

use strict;
use warnings;
use Pod::Usage;
use Smash::Batch;
use Smash::Global qw(:all);
use Smash::CommandLineParser qw(:all);

##############
# Set up command line parsing
##############

my @allowed  = qw(label=s help); # arguments I expect
my @required = qw(label);                       # arguments I require

##############
# Parse command line options
##############

my $status;
my $missing;
my %options;

($status, %options) = parse_options(\@allowed);
if ($options{help}) {
	pod2usage(-exitstatus => 0, -verbose => 2);
}
if ($status != 1) {
	pod2usage(-message => "", -exitstatus => 2, -verbose => 1);
}
#print_options(%options);
($status, $missing) = check_required_options(\@required, %options);
if ($status != 1) {
	pod2usage(-message => "$SMASH_SCRIPT_NAME: Missing argument --$missing\n", -exitstatus => 2, -verbose => 1);
}

my $batch_file = shift @ARGV;
if (!$batch_file) {
	pod2usage(-message => "$SMASH_SCRIPT_NAME: Missing batch file\n", -exitstatus => 2, -verbose => 1);
}

##############
# Run
##############

my $batch = "";
open(BATCH, "<$batch_file") || die "Cannot open $batch_file: $!";
while (<BATCH>) {
	$batch .= $_;
}
close(BATCH);

my $instance = Smash::Batch->new (map {uc($_) => $options{$_}} keys %options);
$instance->process_batch($batch);

exit(0);

=head1 Name

runBatch.pl - Run batch commands for Smash.

=head1 Synopsis

	runBatch.pl [options] file

=head1 Options

=over 4

=item B<C<--label>>

label for this run (all the files created for this run will have this as prefix)

=item B<C<--help>>

Prints this manual.

=back

=head1 Description

B<runBatch.pl> is a script that automates running batch jobs for Smash.

=cut
