#! /usr/bin/env perl

use strict;
use warnings;
use Pod::Usage;
use Smash::Core;
use Smash::Global qw($SMASH_SCRIPT_NAME $SMASH_SCRIPT_LOCATION);
use Smash::CommandLineParser qw(parse_options check_required_options);

##############
# Set up command line parsing
##############

my @allowed  = qw(item=s software=s version=s external help); # arguments I expect
my @required = ();            # arguments I require

##############
# Parse command line options
##############

my $status;
my $missing;
my %options;

($status, %options) = parse_options(\@allowed);
if ($options{help}) {
	pod2usage(-exitstatus => 0, -verbose => 2);
}
if ($status != 1) {
	pod2usage(-message => "", -exitstatus => 2, -verbose => 1);
}

my $item     = $options{item};
my $external = $options{external};
my $software = $options{software};

#print_options(%options);
if (!($item || $external || $software)) {
	pod2usage(-message => "$SMASH_SCRIPT_NAME: Requires one of --item, --software or --external", -exitstatus => 2, -verbose => 1);
}

my $smash = new Smash::Core();

if (defined($external) || ($item && $item eq "external")) {
	$smash->init();
		print "external_dir : ".$smash->get_smash_conf_value("data_dir")."/external/\n";
	$smash->finish();
} elsif (defined($software)) {
	$smash->init();
	my ($location, $version) = $smash->software_dir($software, $options{version} || "current");
	print "software_dir  : $location\n";
	print "curr. version : $version\n";
} else {
	$smash->init($item);
	if ($smash->genepred) {
		print "genepred_dir : ".$smash->genepred_dir($item)."\n";
	}
	if ($smash->assembly) {
		print "assembly_dir : ".$smash->assembly_dir($item)."\n";
	}
	if ($smash->metagenome) {
		print "read_dir     : ".$smash->read_dir($item)."\n";
		print "analyses_dir : ".$smash->analyses_dir($item)."\n";
	}
	$smash->finish();
}

exit(0);
