#include <limits.h>
#include "mQual.h"
#include "zoeTools.h"

int main(int argc, char* argv[]) {
	mQual *qual;
	FILE *stream, *list_stream, *out;
	char line[LINE_MAX];
	int status;
	int i;
	zoeHash keep;
	zoeTVec keys;
	if (argc < 4) {
		mDie("Usage:%s <input_qual_file> <list_file> <output_qual_file>", argv[0]);
	}
	if ((stream = fopen(argv[1], "r")) == NULL) {
		mDie("Cannot open qual file %s for reading", argv[1]);
	}
	if ((list_stream = fopen(argv[2], "r")) == NULL) {
		mDie("Cannot open list file %s for reading", argv[2]);
	}
	if ((out = fopen(argv[3], "w")) == NULL) {
		mDie("Cannot open output file %s for reading", argv[3]);
	}

	keep = zoeNewHash();
	while (fgets(line, LINE_MAX, list_stream) != NULL) {
		char def[LINE_MAX];
		int *code;
		if (sscanf(line, "%s", def) != 1) {
			mDie("LIST LINE ERROR");
		}
		code = (int*) mMalloc(sizeof(int));
		*code = 1;
		zoeSetHash(keep, def, code);
	}

	qual = (mQual*) mMalloc(sizeof(mQual));
	while ((status=mReadQual(stream, qual))) {
		char *key    = mGetFirstWord(qual->def);
		int  *ptr    = (int*)zoeGetHash(keep, key);
		if (ptr != NULL) { 
			mWriteQual(out, qual);
		}
		mFreeQual(qual);
		mFree(key);
		if (status==END_OF_QUAL) break;
	}
	fclose(list_stream);
	fclose(stream);
	fclose(out);

	/* Free memory etc */
	keys = zoeKeysOfHash(keep);
	for (i=0; i<keys->size; i++) {
		mFree(zoeGetHash(keep, keys->elem[i]));
	}
	zoeDeleteTVec(keys);
	zoeDeleteHash(keep);
	mFree(qual);

	exit(0);
}
