#include "mCommon.h"
#include "bam.h"
#include "sam.h"

/*
 *
 * bam1_t related
 *
 */

#define bam1_qfrag(b) (((char*)b->data)[strlen((char*)b->data)-1] - '1')
#define target_taxlen(x) (strchr(x, '.') - x + 1)
#define bam1_templatecmp(a,b) (strncmp(bam1_qname(a), bam1_qname(b), strlen(bam1_qname(a))-1))

#define M_BAM_FOUTIE   2048
#define M_BAM_FUNIDIR  4096

/* get the length of the alignment (i.e., excluding the hard/soft masks in the ends) */

int32_t bam_cigar2alnlen(const bam1_core_t *c, const uint32_t *cigar);

/* get the details of the alignment */

void bam_cigar2details(const bam1_core_t *c, const uint32_t *cigar, int32_t *alen, int32_t *qlen, int32_t *qclip);

/*
 *
 * mBamVector
 *
 */

struct mBamVector {
	int size;
	int limit;
	bam1_t **elem;
};
typedef struct mBamVector mBamVector;

void mInitBamVector(mBamVector *vec, int limit);
void mPushBamVector(mBamVector *vec, bam1_t *item);
void mExpandBamVector(mBamVector *vec);
void mFreeBamVector(mBamVector *vec);
void mEmptyBamVector(mBamVector *vec);
void mSortBamVector(mBamVector *vec, int(*compar)(const void *, const void *));
void mWriteBamVector(samfile_t *stream, mBamVector *bamvector);

/*
 *
 * mBamPool
 *
 */

struct mBamPool {
	int limit;
	int origin;
	int current;
	bam1_t **elem;
};
typedef struct mBamPool mBamPool;

#define pool_current(a) (a->elem[a->current])

void mInitBamPool(mBamPool *pool, int limit);
void mExpandBamPool(mBamPool *pool);
void mFreeBamPool(mBamPool *pool);
bam1_t* mAdvanceBamPool(mBamPool *pool);
void mReOriginateBamPool(mBamPool *pool);
void mWriteBamPool(samfile_t *stream, mBamPool *pool);

