#ifndef _M_DNA_H_
#define _M_DNA_H_

#include "mCommon.h"
#include "mDefinitions.h"

#define END_OF_FASTA (21)
#define HAS_MORE_SEQUENCE (22)

struct mDNA {
	coor_t  length;
	char   *def;
	char   *data;
	int    *code;
	float   gc;
};
typedef struct mDNA mDNA;

void mFreeDNA(mDNA *dna);
void mFreeDNAVector(mVector *vec);
int  mReadDNA(FILE *stream, mDNA *dna);
int  mReadDNALite(FILE *stream, mDNA *dna);
void mCalculateDNACode(mDNA *dna);
void mWriteDNA(FILE *stream, struct mDNA *dna);
void mWriteFixedLengthDNA(FILE *stream, struct mDNA *dna, int columns);
int  mReadMultipleDNA(FILE *stream, mVector *multi);
void mWriteMultipleDNA(FILE *stream, mVector *multi);
float mGetGC(mDNA *dna);

void mReverseComplementDNA(mDNA *dna);
void mSplitDNAToFiles(char *prefix, mDNA *dna, coor_t chunk);
void mBreakAndWriteDNA(FILE *stream, mDNA *dna, coor_t chunk);

char* mDNA2Char(mDNA *dna);
void mProcessDNADef(mDNA *dna);

/* Never free anything other than the mDNA* that was returned */
mDNA* mSubDNA(mDNA *dna, coor_t offset, coor_t length);

#endif
