#ifndef _M_QUAL_H_
#define _M_QUAL_H_

#include "mCommon.h"
#include "mDefinitions.h"

#define END_OF_QUAL (21)
#define HAS_MORE_QUAL (22)

struct mQual {
	coor_t  length;
	char   *def;
	int    *data;
};
typedef struct mQual mQual;

void mFreeQual(mQual *qual);
void mFreeQualVector(mVector *vec);
void mInitQual(mQual *qual, int bases);
int  mReadQual(FILE *stream, mQual *qual);
void mWriteQual(FILE *stream, struct mQual *qual);
int  mReadMultipleQual(FILE *stream, mVector *multi);
void mWriteMultipleQual(FILE *stream, mVector *multi);

void mSplitQualToFiles(char *prefix, mQual *qual, coor_t chunk);
void mBreakAndWriteQual(FILE *stream, mQual *qual, coor_t chunk);

void mReverseComplementQual(mQual *qual);
void mProcessQualDef(mQual *qual);

/* Never free anything other than the mQual* that was returned */
mQual* mSubQual(mQual *qual, coor_t offset, coor_t length);

char *mFastqString(mQual *qual, int reverse);
char *mFastqBytes(mQual *qual, int reverse);

#endif
