#include <limits.h>
#include "mDNA.h"
#include "mQual.h"

int main(int argc, char* argv[]) {
	mDNA *shorter = (mDNA*) mMalloc(sizeof(mDNA));
	mDNA *longer  = (mDNA*) mMalloc(sizeof(mDNA));
	mDNA *sub;
	FILE *longer_stream, *shorter_stream;
	if (argc < 3) {
		mDie("Usage:%s <longer_fasta> <shorter_fasta>", argv[0]);
	}
	if ((longer_stream = fopen(argv[1], "r")) == NULL) {
		mDie("Cannot open %s for reading", argv[1]);
	}
	if ((shorter_stream = fopen(argv[2], "r")) == NULL) {
		mDie("Cannot open %s for reading", argv[2]);
	}
	for (;;) {
		int s_status, l_status;
		s_status = mReadDNA(shorter_stream, shorter);
		l_status = mReadDNA(longer_stream, longer); 
		while (strncmp(shorter->def, longer->def, MIN(strlen(shorter->def), strlen(longer->def))) != 0) {
			mFreeDNA(longer);
			l_status = mReadDNA(longer_stream, longer); 
		}
		sub = mSubDNA(longer, 0, shorter->length);
		mWriteFixedLengthDNA(stdout, sub, 60);
		mFree(sub);
		mFreeDNA(shorter);
		mFreeDNA(longer);
		if (s_status == END_OF_FASTA || l_status == END_OF_FASTA) break; /* last entry */
	}
	fclose(shorter_stream);
	fclose(longer_stream);
	exit(0);
}
