#include <limits.h>
#include "mQual.h"

#define PROCESS_FASTA_HEADER

/*
triminfo format:

Option 1:
~~~~~~~~~
name	start	stop	length	score

Meaning:
~~~~~~~~
Coordinates are 0-based here.
spit out sequence <name> from <start> with length <length>
<stop> is redundant

Special cases:
~~~~~~~~~~~~~~
length=-1 --> no clipping

Option 2:
~~~~~~~~~
name

Meaning:
~~~~~~~~
spit out the complete sequence
equivalent to length=-1

Option 3:
~~~~~~~~~
name	-10	end-piece1	end-piece2	score

Meaning:
~~~~~~~~
Coordinates are 1-based here.
Split sequence <name> into two pieces:
piece1: [1, <end-piece1>]
piece2: [<end-piece2>, end_of_sequence]


*/
int main(int argc, char* argv[]) {
	mQual *qual = (mQual*) mMalloc(sizeof(mQual));
	mQual *sub;
	FILE *stream, *trim_stream;
	char line[LINE_MAX];
	int min_length = 1;
	if (argc < 3) {
		mDie("Usage:%s <fasta_file> <trim_info>", argv[0]);
	}
	if ((stream = fopen(argv[1], "r")) == NULL) {
		mDie("Cannot open %s for reading", argv[1]);
	}
	if ((trim_stream = fopen(argv[2], "r")) == NULL) {
		mDie("Cannot open %s for reading", argv[2]);
	}
	for (;;) {
		int status;
		char def[LINE_MAX];
		long  start, stop, length;
		float score;
		int   code;
		long  end_first, beg_second;
		if (fgets(line, LINE_MAX, trim_stream) == NULL) break;
		status = mReadQual(stream, qual); 
#ifdef PROCESS_FASTA_HEADER
		mProcessQualDef(qual);
#endif
		if (sscanf(line, "%s\t%ld\t%ld\t%ld\t%f", def, &start, &stop, &length, &score) == 5) {
			if (strncmp(def, qual->def, strlen(def)) != 0) mDie("Unmatched definitions found");
			if (length == -1) { /* No clipping */
				start = 0;
				length = qual->length;
			}
			sub = mSubQual(qual, start, length);
			if (length >= min_length) mWriteQual(stdout, sub);
			mFree(sub);
			mFreeQual(qual);
		} else if (sscanf(line, "%s\t%d\t%ld\t%ld", def, &code, &end_first, &beg_second) == 4 && code == -10) {
			char *split_def = (char*) mMalloc((16+strlen(qual->def))*sizeof(char));
			if (strncmp(def, qual->def, strlen(def)) != 0) mDie("Unmatched definitions found");
			sub = mSubQual(qual, 0, end_first);
			sprintf(split_def, "p1_%s", qual->def);
			sub->def = split_def;
			if (length >= min_length) mWriteQual(stdout, sub);
			mFree(sub);
			sub = mSubQual(qual, beg_second-1, qual->length - beg_second + 1);
			sprintf(split_def, "p2_%s", qual->def);
			sub->def = split_def;
			if (length >= min_length) mWriteQual(stdout, sub);
			mFree(sub);
			mFreeQual(qual);
		} else if (sscanf(line, "%s", def) == 1) {
			/* move through the fasta file until you get the corresponding entry */
			/* then write the complete sequence */
			while (strncmp(def, qual->def, strlen(def)) != 0) {
				mFreeQual(qual);
				status = mReadQual(stream, qual);
#ifdef PROCESS_FASTA_HEADER
				mProcessQualDef(qual);
#endif
			}
			min_length = 0;
			mWriteQual(stdout, qual);
			mFreeQual(qual);
		} else {
			mDie("TRIM LINE ERROR");
		}
		if (status == END_OF_QUAL) break; /* last entry */
	}
	fclose(trim_stream);
	fclose(stream);
	exit(0);
}
