#include <limits.h>
#include "mDNA.h"
#include "mQual.h"

int main(int argc, char* argv[]) {
	mDNA *dna = (mDNA*) mMalloc(sizeof(mDNA));
	mQual *qual = (mQual*) mMalloc(sizeof(mQual));
	mQual *sub;
	FILE *stream, *fasta_stream;
	if (argc < 3) {
		mDie("Usage:%s <qual_file> <fasta_file>", argv[0]);
	}
	if ((stream = fopen(argv[1], "r")) == NULL) {
		mDie("Cannot open %s for reading", argv[1]);
	}
	if ((fasta_stream = fopen(argv[2], "r")) == NULL) {
		mDie("Cannot open %s for reading", argv[2]);
	}
	for (;;) {
		int status;
		mReadDNA(fasta_stream, dna);
		status = mReadQual(stream, qual); 
		while (strncmp(dna->def, qual->def, MIN(strlen(dna->def), strlen(qual->def))) != 0) {
			mFreeQual(qual);
			status = mReadQual(stream, qual);
		}
		sub = mSubQual(qual, 0, dna->length);
		mWriteQual(stdout, sub);
		mFree(sub);
		mFreeQual(qual);
		mFreeDNA(dna);
		if (status == END_OF_QUAL) break; /* last entry */
	}
	fclose(fasta_stream);
	fclose(stream);
	exit(0);
}
