
class auc_preparation:
	@staticmethod
	def execute(**kwargs):
		'''
		AUC-FILTERING AND PROCESSING
		'''
		folder = kwargs.get('folder', '')

		print('gather_correlation_values')
		all_dictionaries = auc_preparation.gather_correlation_values(folder)
		print('prepare_auc_dfs')
		df_dict = auc_preparation.prepare_auc_dfs(all_dictionaries)
		print('get_summary_auc')
		auc_df = auc_preparation.get_summary_auc(df_dict)
		print('export_dataframes')
		auc_preparation.export_dataframes(df_dict, auc_df)

	@staticmethod
	def gather_correlation_values(folder):
		print('gather_complex_correlation_values')
		com_yeast_dict = auc_preparation.gather_complex_correlation_values(folder)
		print('gather_pathway_correlation_values')
		pat_yeast_dict = auc_preparation.gather_pathway_correlation_values(folder)
		print('gather_string_and_other_correlation_values')
		string_yeast_dict, string700_yeast_dict, other_yeast_dict = auc_preparation.gather_string_and_other_correlation_values(folder)
		print('gather_essentiality_correlation_values')
		ess_yeast_dict = auc_preparation.gather_essentiality_correlation_values(folder)
		print('gather_housekeeping_correlation_values')
		house_yeast_dict = auc_preparation.gather_housekeeping_correlation_values(folder)
		print('gather_compartment_correlation_values')
		comp_yeast_dict = auc_preparation.gather_compartment_correlation_values(folder)
		print('gather_chromosome_correlation_values')
		chrom_yeast_dict = auc_preparation.gather_chromosome_correlation_values(folder)
		print('gather_other_correlation_values')
		other_com_yeast_dict, other_pat_yeast_dict = auc_preparation.gather_other_correlation_values(other_yeast_dict, com_yeast_dict, pat_yeast_dict)
		return com_yeast_dict, pat_yeast_dict, string_yeast_dict, string700_yeast_dict, other_yeast_dict, ess_yeast_dict, house_yeast_dict, comp_yeast_dict, chrom_yeast_dict, other_com_yeast_dict, other_pat_yeast_dict

	@staticmethod
	def prepare_auc_dfs(all_dictionaries):
		com_yeast_dict, pat_yeast_dict, string_yeast_dict, string700_yeast_dict, other_yeast_dict, ess_yeast_dict, house_yeast_dict, comp_yeast_dict, chrom_yeast_dict, other_com_yeast_dict, other_pat_yeast_dict = all_dictionaries
		keys = list(com_yeast_dict.keys())

		dict_organization = {'complex': com_yeast_dict,
							 'pathway': pat_yeast_dict,
							 'string': string_yeast_dict, 
							 'string700':string700_yeast_dict,
							 'essential': ess_yeast_dict,
							 'housekeeping': house_yeast_dict,
							 'compartment':comp_yeast_dict,
							 'chromosome': chrom_yeast_dict}
		modules = list(dict_organization.keys())

		df_dict = dict((e1,dict()) for e1 in keys)
		for key in keys:
			df_dict[key] = dict((e1,list()) for e1 in modules)
			for module in modules:
				correlation_values = dict_organization[module][key]
				if module == 'complex':
					other_correlations = other_com_yeast_dict[key]
				else:
					other_correlations = other_pat_yeast_dict[key]
				total_other_corr_values = other_yeast_dict[key]
				print('prepare_feature_df: ' + key)
				df = auc_preparation.prepare_feature_df(correlation_values, other_correlations, total_other_corr_values)
				df_dict[key][module] = df
		return df_dict

	@staticmethod
	def get_summary_auc(df_dict):
		summary_dict = dict((e1,dict()) for e1 in list(df_dict.keys()))
		for key in list(df_dict.keys()):
			modules = list(df_dict[key])
			summary_dict[key] = dict((e1,list()) for e1 in modules)
			for module in modules:
				auc_value = df_dict[key][module]['auc'][0]
				summary_dict[key][module] = auc_value
		auc_df = pd.DataFrame(summary_dict)
		return auc_df

	@staticmethod
	def export_dataframes(df_dict, auc_df, folder):
		auc_df.to_csv(folder + 'aucData_summary_yeast_auc_df.tsv.gz', sep = '\t', compression = 'gzip')

		summary_dict = dict((e1,dict()) for e1 in list(df_dict.keys()))
		for key in list(df_dict.keys()):
			modules = list(df_dict[key])
			summary_dict[key] = dict((e1,list()) for e1 in modules)
			concat_list = list()
			for module in modules:
				df = df_dict[key][module]
				df['module'] = pd.Series([module]*len(df), index = df.index)
				concat_list.append(df)
			print('export: ' + key)
			df = pd.concat(concat_list)
			df.to_csv(folder + 'aucData_' + key + '_data_auroc_curves.tsv.gz', sep = '\t', compression = 'gzip')

	@staticmethod
	def gather_complex_correlation_values(folder):
		yeast_datasets = ['yeast' + str(i) for i in [3, 4, 5, 10, 11, 14, 16, 18, 19, 20, 21]]
		com_yeast_dict = dict((e1,list()) for e1 in yeast_datasets)

		fname = 'yeast3_quant_Proteome_carbonSources_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'rel. Intensity')
		print('get_complex_correlation_values:yeast3')
		com_corrs, all_genes = auc_preparation.get_complex_correlation_values(data, quant_cols)
		com_yeast_dict['yeast3'] = com_corrs
		##################################################################################
		fname = 'yeast4_quant_Proteome_naclStress_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'rel.Intensity')
		print('get_complex_correlation_values:yeast4')
		com_corrs, all_genes = auc_preparation.get_complex_correlation_values(data, quant_cols)
		com_yeast_dict['yeast4'] = com_corrs
		##################################################################################
		fname = 'yeast5_quant_Proteome_MAPPED_complexes_pathways_NORM2_IBAQ.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'iBAQ')[:-1]
		print('get_complex_correlation_values:yeast5')
		com_corrs, all_genes = auc_preparation.get_complex_correlation_values(data, quant_cols)
		com_yeast_dict['yeast5'] = com_corrs
		##################################################################################
		fname = 'yeast10_quant_RNA_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant')
		print('get_complex_correlation_values:yeast10')
		com_corrs, all_genes = auc_preparation.get_complex_correlation_values(data, quant_cols)
		com_yeast_dict['yeast10'] = com_corrs
		##################################################################################
		fname = 'yeast11_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant')
		print('get_complex_correlation_values:yeast11')
		com_corrs, all_genes = auc_preparation.get_complex_correlation_values(data, quant_cols)
		com_yeast_dict['yeast11'] = com_corrs
		##################################################################################
		fname = 'yeast14_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_complex_correlation_values:yeast14')
		com_corrs, all_genes = auc_preparation.get_complex_correlation_values(data, quant_cols)
		com_yeast_dict['yeast14'] = com_corrs
		##################################################################################
		fname = 'yeast16_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_complex_correlation_values:yeast16')
		com_corrs, all_genes = auc_preparation.get_complex_correlation_values(data, quant_cols)
		com_yeast_dict['yeast16'] = com_corrs
		##################################################################################
		fname = 'yeast18_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_complex_correlation_values:yeast18')
		com_corrs, all_genes = auc_preparation.get_complex_correlation_values(data, quant_cols)
		com_yeast_dict['yeast18'] = com_corrs
		##################################################################################
		fname = 'yeast19_quant_transcriptome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_complex_correlation_values:yeast19')
		com_corrs, all_genes = auc_preparation.get_complex_correlation_values(data, quant_cols)
		com_yeast_dict['yeast19'] = com_corrs
		##################################################################################
		fname = 'yeast20_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_complex_correlation_values:yeast20')
		com_corrs, all_genes = auc_preparation.get_complex_correlation_values(data, quant_cols)
		com_yeast_dict['yeast20'] = com_corrs
		##################################################################################
		fname = 'yeast21_quant_proteome_MAPPED_complexes_pathways_NORM2_REP.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_complex_correlation_values:yeast21')
		com_corrs, all_genes = auc_preparation.get_complex_correlation_values(data, quant_cols)
		com_yeast_dict['yeast21'] = com_corrs
		return com_yeast_dict

	@staticmethod
	def gather_pathway_correlation_values(folder):
		yeast_datasets = ['yeast' + str(i) for i in [3, 4, 5, 10, 11, 14, 16, 18, 19, 20, 21]]
		pat_yeast_dict = dict((e1,list()) for e1 in yeast_datasets)

		fname = 'yeast3_quant_Proteome_carbonSources_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'rel. Intensity')
		print('get_pathway_correlation_values:yeast3')
		com_corrs, all_genes = auc_preparation.get_pathway_correlation_values(data, quant_cols)
		pat_yeast_dict['yeast3'] = com_corrs
		##################################################################################
		fname = 'yeast4_quant_Proteome_naclStress_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'rel.Intensity')
		print('get_pathway_correlation_values:yeast4')
		com_corrs, all_genes = auc_preparation.get_pathway_correlation_values(data, quant_cols)
		pat_yeast_dict['yeast4'] = com_corrs
		##################################################################################
		fname = 'yeast5_quant_Proteome_MAPPED_complexes_pathways_NORM2_IBAQ.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'iBAQ')[:-1]
		print('get_pathway_correlation_values:yeast5')
		com_corrs, all_genes = auc_preparation.get_pathway_correlation_values(data, quant_cols)
		pat_yeast_dict['yeast5'] = com_corrs
		##################################################################################
		fname = 'yeast10_quant_RNA_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant')
		print('get_pathway_correlation_values:yeast10')
		com_corrs, all_genes = auc_preparation.get_pathway_correlation_values(data, quant_cols)
		pat_yeast_dict['yeast10'] = com_corrs
		##################################################################################
		fname = 'yeast11_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant')
		print('get_pathway_correlation_values:yeast11')
		com_corrs, all_genes = auc_preparation.get_pathway_correlation_values(data, quant_cols)
		pat_yeast_dict['yeast11'] = com_corrs
		##################################################################################
		fname = 'yeast14_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_pathway_correlation_values:yeast14')
		com_corrs, all_genes = auc_preparation.get_pathway_correlation_values(data, quant_cols)
		pat_yeast_dict['yeast14'] = com_corrs
		##################################################################################
		fname = 'yeast16_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_pathway_correlation_values:yeast16')
		com_corrs, all_genes = auc_preparation.get_pathway_correlation_values(data, quant_cols)
		pat_yeast_dict['yeast16'] = com_corrs
		##################################################################################
		fname = 'yeast18_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_pathway_correlation_values:yeast18')
		com_corrs, all_genes = auc_preparation.get_pathway_correlation_values(data, quant_cols)
		pat_yeast_dict['yeast18'] = com_corrs
		##################################################################################
		fname = 'yeast19_quant_transcriptome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_pathway_correlation_values:yeast19')
		com_corrs, all_genes = auc_preparation.get_pathway_correlation_values(data, quant_cols)
		pat_yeast_dict['yeast19'] = com_corrs
		##################################################################################
		fname = 'yeast20_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_pathway_correlation_values:yeast20')
		com_corrs, all_genes = auc_preparation.get_pathway_correlation_values(data, quant_cols)
		pat_yeast_dict['yeast20'] = com_corrs
		##################################################################################
		fname = 'yeast21_quant_proteome_MAPPED_complexes_pathways_NORM2_REP.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_pathway_correlation_values:yeast21')
		com_corrs, all_genes = auc_preparation.get_pathway_correlation_values(data, quant_cols)
		pat_yeast_dict['yeast21'] = com_corrs
		return pat_yeast_dict

	@staticmethod
	def gather_string_and_other_correlation_values(folder):
		yeast_datasets = ['yeast' + str(i) for i in [3, 4, 5, 10, 11, 14, 16, 18, 19, 20, 21]]
		string_yeast_dict = dict((e1,list()) for e1 in yeast_datasets)
		string700_yeast_dict = dict((e1,list()) for e1 in yeast_datasets)
		other_yeast_dict = dict((e1,list()) for e1 in yeast_datasets)

		for name in yeast_datasets:
			print(name)
			data_dict = DataFrameAnalyzer.read_pickle(folder + name + '.string.corrs.pkl')
			scorrs, scorrs700, other_corrs = data_dict['string'], data_dict['string700'], data_dict['other']
			string_yeast_dict[name] = scorrs
			string700_yeast_dict[name] = scorrs700
			other_yeast_dict[name] = other_corrs
		return string_yeast_dict, string700_yeast_dict, other_yeast_dict

	@staticmethod
	def gather_essentiality_correlation_values(folder):
		yeast_datasets = ['yeast' + str(i) for i in [3, 4, 5, 10, 11, 14, 16, 18, 19, 20, 21]]
		ess_yeast_dict = dict((e1,list()) for e1 in yeast_datasets)

		fname = 'yeast3_quant_Proteome_carbonSources_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'rel. Intensity')
		print('get_essentiality_correlation_values:yeast3')
		com_corrs = auc_preparation.get_essentiality_correlation_values(folder, data, quant_cols)
		ess_yeast_dict['yeast3'] = com_corrs
		##################################################################################
		fname = 'yeast4_quant_Proteome_naclStress_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'rel.Intensity')
		print('get_essentiality_correlation_values:yeast4')
		com_corrs = auc_preparation.get_essentiality_correlation_values(folder, data, quant_cols)
		ess_yeast_dict['yeast4'] = com_corrs
		##################################################################################
		fname = 'yeast5_quant_Proteome_MAPPED_complexes_pathways_NORM2_IBAQ.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'iBAQ')[:-1]
		print('get_essentiality_correlation_values:yeast5')
		com_corrs = auc_preparation.get_essentiality_correlation_values(folder, data, quant_cols)
		ess_yeast_dict['yeast5'] = com_corrs
		##################################################################################
		fname = 'yeast10_quant_RNA_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant')
		print('get_essentiality_correlation_values:yeast10')
		com_corrs = auc_preparation.get_essentiality_correlation_values(folder, data, quant_cols)
		ess_yeast_dict['yeast10'] = com_corrs
		##################################################################################
		fname = 'yeast11_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant')
		print('get_essentiality_correlation_values:yeast11')
		com_corrs = auc_preparation.get_essentiality_correlation_values(folder, data, quant_cols)
		ess_yeast_dict['yeast11'] = com_corrs
		##################################################################################
		fname = 'yeast14_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_essentiality_correlation_values:yeast14')
		com_corrs = auc_preparation.get_essentiality_correlation_values(folder, data, quant_cols)
		ess_yeast_dict['yeast14'] = com_corrs
		##################################################################################
		fname = 'yeast16_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_essentiality_correlation_values:yeast16')
		com_corrs = auc_preparation.get_essentiality_correlation_values(folder, data, quant_cols)
		ess_yeast_dict['yeast16'] = com_corrs
		##################################################################################
		fname = 'yeast18_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_essentiality_correlation_values:yeast18')
		com_corrs = auc_preparation.get_essentiality_correlation_values(folder, data, quant_cols)
		ess_yeast_dict['yeast18'] = com_corrs
		##################################################################################
		fname = 'yeast19_quant_transcriptome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_pathway_correlation_values:yeast19')
		com_corrs = auc_preparation.get_essentiality_correlation_values(folder, data, quant_cols)
		ess_yeast_dict['yeast19'] = com_corrs
		##################################################################################
		fname = 'yeast20_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_essentiality_correlation_values:yeast20')
		com_corrs = auc_preparation.get_essentiality_correlation_values(folder, data, quant_cols)
		ess_yeast_dict['yeast20'] = com_corrs
		##################################################################################
		fname = 'yeast21_quant_proteome_MAPPED_complexes_pathways_NORM2_REP.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_essentiality_correlation_values:yeast21')
		com_corrs = auc_preparation.get_essentiality_correlation_values(folder, data, quant_cols)
		ess_yeast_dict['yeast21'] = com_corrs
		return ess_yeast_dict

	@staticmethod
	def gather_housekeeping_correlation_values(folder):
		yeast_datasets = ['yeast' + str(i) for i in [3, 4, 5, 10, 11, 14, 16, 18, 19, 20, 21]]
		house_yeast_dict = dict((e1,list()) for e1 in yeast_datasets)

		fname = 'yeast3_quant_Proteome_carbonSources_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'rel. Intensity')
		print('get_housekeeping_correlation_values:yeast3')
		com_corrs = auc_preparation.get_housekeeping_correlation_values(folder, data, quant_cols)
		house_yeast_dict['yeast3'] = com_corrs
		##################################################################################
		fname = 'yeast4_quant_Proteome_naclStress_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'rel.Intensity')
		print('get_housekeeping_correlation_values:yeast4')
		com_corrs = auc_preparation.get_housekeeping_correlation_values(folder, data, quant_cols)
		house_yeast_dict['yeast4'] = com_corrs
		##################################################################################
		fname = 'yeast5_quant_Proteome_MAPPED_complexes_pathways_NORM2_IBAQ.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'iBAQ')[:-1]
		print('get_housekeeping_correlation_values:yeast5')
		com_corrs = auc_preparation.get_housekeeping_correlation_values(folder, data, quant_cols)
		house_yeast_dict['yeast5'] = com_corrs
		##################################################################################
		fname = 'yeast10_quant_RNA_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant')
		print('get_housekeeping_correlation_values:yeast10')
		com_corrs = auc_preparation.get_housekeeping_correlation_values(folder, data, quant_cols)
		house_yeast_dict['yeast10'] = com_corrs
		##################################################################################
		fname = 'yeast11_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant')
		print('get_housekeeping_correlation_values:yeast11')
		com_corrs = auc_preparation.get_housekeeping_correlation_values(folder, data, quant_cols)
		house_yeast_dict['yeast11'] = com_corrs
		##################################################################################
		fname = 'yeast14_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_housekeeping_correlation_values:yeast14')
		com_corrs = auc_preparation.get_housekeeping_correlation_values(folder, data, quant_cols)
		house_yeast_dict['yeast14'] = com_corrs
		##################################################################################
		fname = 'yeast16_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_housekeeping_correlation_values:yeast16')
		com_corrs = auc_preparation.get_housekeeping_correlation_values(folder, data, quant_cols)
		house_yeast_dict['yeast16'] = com_corrs
		##################################################################################
		fname = 'yeast18_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_housekeeping_correlation_values:yeast18')
		com_corrs = auc_preparation.get_housekeeping_correlation_values(folder, data, quant_cols)
		house_yeast_dict['yeast18'] = com_corrs
		##################################################################################
		fname = 'yeast19_quant_transcriptome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_housekeeping_correlation_values:yeast19')
		com_corrs = auc_preparation.get_housekeeping_correlation_values(folder, data, quant_cols)
		house_yeast_dict['yeast19'] = com_corrs
		##################################################################################
		fname = 'yeast20_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_housekeeping_correlation_values:yeast20')
		com_corrs = auc_preparation.get_housekeeping_correlation_values(folder, data, quant_cols)
		house_yeast_dict['yeast20'] = com_corrs
		##################################################################################
		fname = 'yeast21_quant_proteome_MAPPED_complexes_pathways_NORM2_REP.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_housekeeping_correlation_values:yeast21')
		com_corrs = auc_preparation.get_housekeeping_correlation_values(folder, data, quant_cols)
		house_yeast_dict['yeast21'] = com_corrs
		return house_yeast_dict

	@staticmethod
	def gather_compartment_correlation_values(folder):
		yeast_datasets = ['yeast' + str(i) for i in [3, 4, 5, 10, 11, 14, 16, 18, 19, 20, 21]]
		comp_yeast_dict = dict((e1,list()) for e1 in yeast_datasets)

		fname = 'yeast3_quant_Proteome_carbonSources_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'rel. Intensity')
		print('get_compartment_correlation_values:yeast3')
		com_corrs = auc_preparation.get_compartment_correlation_values(folder, data, quant_cols)
		comp_yeast_dict['yeast3'] = com_corrs
		##################################################################################
		fname = 'yeast4_quant_Proteome_naclStress_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'rel.Intensity')
		print('get_compartment_correlation_values:yeast4')
		com_corrs = auc_preparation.get_compartment_correlation_values(folder, data, quant_cols)
		comp_yeast_dict['yeast4'] = com_corrs
		##################################################################################
		fname = 'yeast5_quant_Proteome_MAPPED_complexes_pathways_NORM2_IBAQ.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'iBAQ')[:-1]
		print('get_compartment_correlation_values:yeast5')
		com_corrs = auc_preparation.get_compartment_correlation_values(folder, data, quant_cols)
		comp_yeast_dict['yeast5'] = com_corrs
		##################################################################################
		fname = 'yeast10_quant_RNA_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant')
		print('get_compartment_correlation_values:yeast10')
		com_corrs = auc_preparation.get_compartment_correlation_values(folder, data, quant_cols)
		comp_yeast_dict['yeast10'] = com_corrs
		##################################################################################
		fname = 'yeast11_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant')
		print('get_compartment_correlation_values:yeast11')
		com_corrs = auc_preparation.get_compartment_correlation_values(folder, data, quant_cols)
		comp_yeast_dict['yeast11'] = com_corrs
		##################################################################################
		fname = 'yeast14_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_compartment_correlation_values:yeast14')
		com_corrs = auc_preparation.get_compartment_correlation_values(folder, data, quant_cols)
		comp_yeast_dict['yeast14'] = com_corrs
		##################################################################################
		fname = 'yeast16_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_compartment_correlation_values:yeast16')
		com_corrs = auc_preparation.get_compartment_correlation_values(folder, data, quant_cols)
		comp_yeast_dict['yeast16'] = com_corrs
		##################################################################################
		fname = 'yeast18_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_compartment_correlation_values:yeast18')
		com_corrs = auc_preparation.get_compartment_correlation_values(folder, data, quant_cols)
		comp_yeast_dict['yeast18'] = com_corrs
		##################################################################################
		fname = 'yeast19_quant_transcriptome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_compartment_correlation_values:yeast19')
		com_corrs = auc_preparation.get_compartment_correlation_values(folder, data, quant_cols)
		comp_yeast_dict['yeast19'] = com_corrs
		##################################################################################
		fname = 'yeast20_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_compartment_correlation_values:yeast20')
		com_corrs = auc_preparation.get_compartment_correlation_values(folder, data, quant_cols)
		comp_yeast_dict['yeast20'] = com_corrs
		##################################################################################
		fname = 'yeast21_quant_proteome_MAPPED_complexes_pathways_NORM2_REP.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_compartment_correlation_values:yeast21')
		com_corrs = auc_preparation.get_compartment_correlation_values(folder, data, quant_cols)
		comp_yeast_dict['yeast21'] = com_corrs
		return comp_yeast_dict

	@staticmethod
	def gather_chromosome_correlation_values(folder):
		yeast_datasets = ['yeast' + str(i) for i in [3, 4, 5, 10, 11, 14, 16, 18, 19, 20, 21]]
		chrom_yeast_dict = dict((e1,list()) for e1 in yeast_datasets)

		fname = 'yeast3_quant_Proteome_carbonSources_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'rel. Intensity')
		print('get_chromosome_correlation_values:yeast3')
		com_corrs = auc_preparation.get_chromosome_correlation_values(folder, data, quant_cols)
		chrom_yeast_dict['yeast3'] = com_corrs
		##################################################################################
		fname = 'yeast4_quant_Proteome_naclStress_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'rel.Intensity')
		print('get_chromosome_correlation_values:yeast4')
		com_corrs = auc_preparation.get_chromosome_correlation_values(folder, data, quant_cols)
		chrom_yeast_dict['yeast4'] = com_corrs
		##################################################################################
		fname = 'yeast5_quant_Proteome_MAPPED_complexes_pathways_NORM2_IBAQ.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'iBAQ')[:-1]
		print('get_chromosome_correlation_values:yeast5')
		com_corrs = auc_preparation.get_chromosome_correlation_values(folder, data, quant_cols)
		chrom_yeast_dict['yeast5'] = com_corrs
		##################################################################################
		fname = 'yeast10_quant_RNA_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant')
		print('get_chromosome_correlation_values:yeast10')
		com_corrs = auc_preparation.get_chromosome_correlation_values(folder, data, quant_cols)
		chrom_yeast_dict['yeast10'] = com_corrs
		##################################################################################
		fname = 'yeast11_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant')
		print('get_chromosome_correlation_values:yeast11')
		com_corrs = auc_preparation.get_chromosome_correlation_values(folder, data, quant_cols)
		chrom_yeast_dict['yeast11'] = com_corrs
		##################################################################################
		fname = 'yeast14_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_chromosome_correlation_values:yeast14')
		com_corrs = auc_preparation.get_chromosome_correlation_values(folder, data, quant_cols)
		chrom_yeast_dict['yeast14'] = com_corrs
		##################################################################################
		fname = 'yeast16_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_chromosome_correlation_values:yeast16')
		com_corrs = auc_preparation.get_chromosome_correlation_values(folder, data, quant_cols)
		chrom_yeast_dict['yeast16'] = com_corrs
		##################################################################################
		fname = 'yeast18_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_chromosome_correlation_values:yeast18')
		com_corrs = auc_preparation.get_chromosome_correlation_values(folder, data, quant_cols)
		chrom_yeast_dict['yeast18'] = com_corrs
		##################################################################################
		fname = 'yeast19_quant_transcriptome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_chromosome_correlation_values:yeast19')
		com_corrs = auc_preparation.get_chromosome_correlation_values(folder, data, quant_cols)
		chrom_yeast_dict['yeast19'] = com_corrs
		##################################################################################
		fname = 'yeast20_quant_proteome_MAPPED_complexes_pathways_NORM2.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_chromosome_correlation_values:yeast20')
		com_corrs = auc_preparation.get_chromosome_correlation_values(folder, data, quant_cols)
		chrom_yeast_dict['yeast20'] = com_corrs
		##################################################################################
		fname = 'yeast21_quant_proteome_MAPPED_complexes_pathways_NORM2_REP.tsv.gz'
		data = DataFrameAnalyzer.getFile(folder, fname)
		quant_cols = utilsFacade.filtering(list(data.columns), 'quant_')
		print('get_chromosome_correlation_values:yeast21')
		com_corrs = auc_preparation.get_chromosome_correlation_values(folder, data, quant_cols)
		chrom_yeast_dict['yeast21'] = com_corrs
		return chrom_yeast_dict

	@staticmethod
	def gather_other_correlation_values(other_yeast_dict, com_yeast_dict, pat_yeast_dict):#BAUSTELLE
		other_com_yeast_dict = dict((e1,list()) for e1 in list(other_yeast_dict.keys()))
		other_pat_yeast_dict = dict((e1,list()) for e1 in list(other_yeast_dict.keys()))

		for key in list(other_yeast_dict.keys()):
			complex_correlation_values = com_yeast_dict[key]
			pathway_correlation_values = pat_yeast_dict[key]
			other_correlations = other_yeast_dict[key]
			try:
				complex_other_correlations = random.sample(other_correlations,len(complex_correlation_values))
				pathway_other_correlations = random.sample(other_correlations,len(pathway_correlation_values))
			except:
				complex_other_correlations = other_correlations
				pathway_other_correlations = other_correlations
			other_com_yeast_dict[key] = complex_other_correlations
			other_pat_yeast_dict[key] = pathway_other_correlations
		return other_com_yeast_dict, other_pat_yeast_dict

	@staticmethod
	def load_housekeeping_genes(folder):
		file_name = "housekeeping_genes.txt"
		housekeeping_data = pd.read_csv(folder + file_name, sep = '\t', header = None)

		housekeeping_genes = list(housekeeping_data[0])
		housekeeping_genes = [i[:-1] for i in housekeeping_genes]
		return housekeeping_genes

	@staticmethod
	def load_essential_genes(folder):
		file_name = "essentiality_genes.txt"
		essentiality_data = DataFrameAnalyzer.getFile(folder,file_name)
		kbm7_essentiality_data = essentiality_data[essentiality_data["KBM7 adjusted p-value"] < 0.05]
		k562_essentiality_data = essentiality_data[essentiality_data["K562 adjusted p-value"] < 0.05]
		jiyoye_essentiality_data = essentiality_data[essentiality_data["Jiyoye adjusted p-value"] < 0.05]
		raji_essentiality_data = essentiality_data[essentiality_data["Raji adjusted p-value"] < 0.05]

		kbm7_essential_genes = kbm7_essentiality_data.index
		k562_essential_genes = k562_essentiality_data.index
		jiyoye_essential_genes = jiyoye_essentiality_data.index
		raji_essential_genes = raji_essentiality_data.index
		return kbm7_essential_genes, k562_essential_genes, jiyoye_essential_genes, raji_essential_genes

	@staticmethod
	def load_compartment_genes(folder):
		fileName = "subcellular_location.csv"
		locData = DataFrameAnalyzer.getFile(folder,fileName, delimiter = ',')

		location_list = list()
		for i,row in locData.iterrows():
			item_list = filter(lambda a:str(a)!="nan",[row["Validated"], row["Supported"], row["Approved"]])
			if len(item_list)==0:
				location_list.append("")
			else:
				location_list.append(";".join(item_list))
		locData["location"] = pd.Series(location_list,index = locData.index)
		locData.index = list(locData["Gene name"])
		locDict = locData["location"].to_dict()

		loc_set = list(locData['location'])
		lset = list()
		for l in loc_set:
			for item in l.split(';'):
				lset.append(item)
		lset = filter(lambda a:str(a)!='',list(set(lset)))
		
		loc_name_dict = dict((e1,list()) for e1 in lset)
		for loc in lset:
			sub = locData[locData.location.str.contains(loc)]
			sub_specific = locData[locData.location==loc]
			loc_name_dict[loc] = {'all':list(sub.index), 'specific':list(sub_specific.index)}		
		return locDict, loc_name_dict

	@staticmethod
	def load_chromosome_genes(folder):
		fname = 'orf_coding_all_R64-2-1_20150113.fasta'
		o = open(ffolder + fname, 'rb')
		lines = o.readlines()
		o.close()

		lines = utilsFacade.filtering(lines, '>', condition = 'startswith')
		chromosomes = ["chr" + str(i) for i in list(np.arange(1,20))] + ['Mito']
		chromosome_dict = dict((e1,list()) for e1 in chromosomes)

		roman_number_dict = {'I':1, 'II':2, 'III':3, 'IV':4, 'V':5,
							 'VI':6, 'VII':7, 'VIII':8, 'IX':9, 'X':10,
							 'XI':11, 'XII':12, 'XIII':13, 'XIV':14, 'XV':15,
							 'XVI':16, 'XVII':17,'XVIII':18, 'XIX':19, 'XX':20}
		not_valid_lines = list()
		for line in lines:
			try:
				chromosome = line.split('Chr ')[1].split(' ')[0]
				sgd = line.split(' ')[0][1:]

				if chromosome!='Mito':
					num = roman_number_dict[chromosome]
					chromosome_dict['chr' + str(num)].append(sgd)
				else:
					chromosome_dict['Mito'].append(sgd)
			except:
				not_valid_lines.append(line)
		return chromosome_dict

	@staticmethod
	def get_complex_correlation_values(data, quant_cols):
		complexes = list(set(data.complexId))
		all_complexes = list()
		for com in complexes:
			if str(com)!='nan':
				for c in com.split(';'):
					all_complexes.append(c)
		all_complexes = list(set(all_complexes))

		filtered_complex_members = list()
		filtered_complexes = list()
		for com in all_complexes:
			sub = data[data.complexId.str.contains(com, na = False)]
			if len(sub)>=3:
				filtered_complex_members.append(sub)
				filtered_complexes.append(com)
		filtered_complex_members = pd.concat(filtered_complex_members)
		all_genes = list(set(filtered_complex_members.index))

		quant_data = data[quant_cols]
		complex_corr_values = list()
		for com in filtered_complexes:
			print(com)
			sub = data[data.complexId.str.contains(com, na = False)]
			quant_sub = sub[quant_cols]
			corrData = quant_sub.T.corr()
			corrValues = utilsFacade.get_correlation_values(corrData)
			complex_corr_values.append(corrValues)
		complex_corr_values = utilsFacade.flatten(complex_corr_values)
		return complex_corr_values, all_genes

	@staticmethod
	def get_pathway_correlation_values(data, quant_cols):
		complexes = list(set(data.pathway))
		all_complexes = list()
		for com in complexes:
			if str(com)!='nan':
				for c in com.split(';'):
					all_complexes.append(c)
		all_complexes = list(set(all_complexes))

		filtered_complex_members = list()
		filtered_complexes = list()
		for com in all_complexes:
			sub = data[data.pathway.str.contains(com, na = False, regex = False)]
			if len(sub)>=3:
				filtered_complex_members.append(sub)
				filtered_complexes.append(com)
		filtered_complex_members = pd.concat(filtered_complex_members)
		all_genes = list(set(filtered_complex_members.index))

		quant_data = data[quant_cols]
		complex_corr_values = list()
		for com in filtered_complexes:
			print(com)
			sub = data[data.pathway.str.contains(com, na = False)]
			quant_sub = sub[quant_cols]
			corrData = quant_sub.T.corr()
			corrValues = utilsFacade.get_correlation_values(corrData)
			complex_corr_values.append(corrValues)
		complex_corr_values = utilsFacade.flatten(complex_corr_values)
		return complex_corr_values, all_genes

	@staticmethod
	def get_essentiality_correlation_values(folder, data, quant_cols):
		print('load_essential_genes')
		kbm7, k562, jiyoye, raji = auc_preparation.load_essential_genes(folder)
		all_genes = list(set(data.symbol))
		all_genes = [str(i).split(';') for i in all_genes]
		all_genes = utilsFacade.flatten(all_genes)

		kbm7_essential_genes = list(set(kbm7).intersection(set(all_genes)))
		k562_essential_genes = list(set(k562).intersection(set(all_genes)))
		jiyoye_essential_genes = list(set(jiyoye).intersection(set(all_genes)))
		raji_essential_genes = list(set(raji).intersection(set(all_genes)))

		kbm7 = list()
		k562 = list()
		jiyoye = list()
		raji = list()
		all_genes = list(set(data.symbol))
		for gene in all_genes:
			for g in str(gene).split(';'):
				if g in kbm7_essential_genes:
					kbm7.append(gene)
					break
			for g in str(gene).split(';'):
				if gene in k562_essential_genes:
					k562.append(gene)
					break
			for g in str(gene).split(';'):
				if gene in jiyoye_essential_genes:
					jiyoye.append(gene)
					break
			for g in str(gene).split(';'):
				if gene in raji_essential_genes:
					raji.append(gene)
					break

		data.index = data.symbol
		quant_data = data[quant_cols]
		kbm7_corr = quant_data.T[kbm7].corr()
		k562_corr = quant_data.T[k562].corr()
		jiyoye_corr = quant_data.T[jiyoye].corr()
		raji_corr = quant_data.T[raji].corr()

		kbm7_essential_correlation_values = utilsFacade.get_correlation_values(kbm7_corr)
		k562_essential_correlation_values = utilsFacade.get_correlation_values(k562_corr)
		jiyoye_essential_correlation_values = utilsFacade.get_correlation_values(jiyoye_corr)
		raji_essential_correlation_values = utilsFacade.get_correlation_values(raji_corr)
		essential_correlation_values = kbm7_essential_correlation_values + k562_essential_correlation_values + jiyoye_essential_correlation_values + raji_essential_correlation_values
		return essential_correlation_values

	@staticmethod
	def get_housekeeping_correlation_values(folder, data, quant_cols):
		print('load_housekeeping_genes')
		housekeeping_genes = auc_preparation.load_housekeeping_genes(folder)
		all_genes = list(set(data.symbol))
		all_genes = [str(i).split(';') for i in all_genes]
		all_genes = utilsFacade.flatten(all_genes)

		housekeeping_genes = list(set(housekeeping_genes).intersection(set(all_genes)))

		housekeeping = list()
		all_genes = list(set(data.symbol))
		for gene in all_genes:
			for g in str(gene).split(';'):
				if g in housekeeping_genes:
					housekeeping.append(gene)
					break
		
		data.index = data.symbol
		quant_data = data[quant_cols]
		housekeeping_corr = quant_data.T[housekeeping].corr()

		housekeeping_correlation_values = utilsFacade.get_correlation_values(housekeeping_corr)
		return housekeeping_correlation_values

	@staticmethod
	def get_compartment_correlation_values(folder, data, quant_cols):
		print('load_compartment_genes')
		locDict, loc_name_dict = auc_preparation.load_compartment_genes(folder)
		all_genes = list(set(data.symbol))
		all_genes = [str(i).split(';') for i in all_genes]
		all_genes = utilsFacade.flatten(all_genes)

		all_compartment_correlation_values = list()
		for compartment in loc_name_dict.keys():
			compartment_genes = list(loc_name_dict[compartment]['all'])
			genes = list(set(compartment_genes).intersection(set(all_genes)))

			compartment = list()
			all_symbols = list(set(data.symbol))
			for gene in all_symbols:
				for g in str(gene).split(';'):
					if g in genes:
						compartment.append(gene)
						break

			data.index = data.symbol
			quant_data = data[quant_cols]
			compartment_corr = quant_data.T[compartment].corr()

			compartment_correlation_values = utilsFacade.get_correlation_values(compartment_corr)
			all_compartment_correlation_values.append(compartment_correlation_values)
		all_compartment_correlation_values = utilsFacade.flatten(all_compartment_correlation_values)
		return all_compartment_correlation_values

	@staticmethod
	def get_chromosome_correlation_values(folder, data, quant_cols):
		print('load_chromosome_genes')
		chromosome_dict = auc_preparation.load_chromosome_genes(folder)
		all_genes = list(set(data.index))

		all_chrom_correlation_values = list()
		for chrom in chromosome_dict.keys():
			chrom_genes = list(chromosome_dict[chrom])
			genes = list(set(chrom_genes).intersection(set(all_genes)))

			quant_data = data[quant_cols]
			chrom_corr = quant_data.T[genes].corr()

			chrom_correlation_values = utilsFacade.get_correlation_values(chrom_corr)
			all_chrom_correlation_values.append(chrom_correlation_values)
		all_chrom_correlation_values = utilsFacade.flatten(all_chrom_correlation_values)
		return all_chrom_correlation_values

	@staticmethod
	def get_auroc_n_auprc(y_true, y_pred):
		auroc = roc_auc_score(y_true, y_pred)
		auprc = average_precision_score(y_true, y_pred)
		return auroc, auprc

	@staticmethod
	def prepare_feature_df(correlation_values, other_correlations, total_other_corr_values):
		if len(other_correlations) > len(correlation_values):
			compartment_other_correlations = random.sample(other_correlations,len(correlation_values))
		else:
			compartment_other_correlations = other_correlations

		df = pd.DataFrame({"correlations": correlation_values + compartment_other_correlations,
						   "label": [True]*len(correlation_values) + [False]*len(compartment_other_correlations)})
		df = df.sort_values("correlations", ascending = True)

		y_pred = correlation_values + compartment_other_correlations
		y_true = [1]*len(correlation_values) + [0]*len(compartment_other_correlations)
		auroc, auprc = auc_preparation.get_auroc_n_auprc(y_true, y_pred)

		positives_length = len(correlation_values)
		active_negatives_length = len(compartment_other_correlations)
		real_negatives_length = len(total_other_corr_values)
		real_balance = float(positives_length)/float(real_negatives_length)
		active_balance = float(positives_length)/float(active_negatives_length)

		count_list = list()
		dec_list = list(utilsFacade.frange(-1,1,0.01))
		max_corr = df["correlations"].max()
		for count,dec in enumerate(list(reversed(np.array(dec_list)))):
			if dec < max_corr:
				break
		idx = count + 1

		df_small = pd.DataFrame({"correlations":dec_list[:-idx]})
		fpr_list = list()
		tpr_list = list()
		recall_list = list()
		accuracy_list = list()
		precision_list = list()
		all_true_positives = len(df[df.label == True])
		all_false_positives = len(df[df.label == False])
		for t in dec_list[:-idx]:
			rejected = df[df["correlations"]<t]
			sub = df[df["correlations"]>=t]
			true_positives = float(len(sub[sub.label == True]))
			false_positives = float(len(sub[sub.label == False]))
			false_negatives = float(len(rejected.label == True))
			true_negatives = float(len(rejected.label == False))
			tpr = true_positives/all_true_positives
			fpr = false_positives/all_false_positives
			precision = true_positives/(true_positives + false_positives)
			recall = true_positives/(true_positives + false_negatives)
			accuracy = (true_positives + true_negatives)/(true_positives + true_negatives + false_positives + false_negatives)
			fpr_list.append(fpr)
			tpr_list.append(tpr)
			recall_list.append(recall)
			accuracy_list.append(accuracy)
			precision_list.append(precision)
		df_small["fpr"] = pd.Series(fpr_list, index = df_small.index)
		df_small["tpr"] = pd.Series(tpr_list, index = df_small.index)
		df_small["recall"] = pd.Series(recall_list, index = df_small.index)
		df_small["accuracy"] = pd.Series(accuracy_list, index = df_small.index)
		df_small["precision"] = pd.Series(precision_list, index = df_small.index)
		auc_value = sklearn.metrics.auc(fpr_list,tpr_list)
		df_small["auc"] = [auc_value]*len(df_small)
		df_small["auroc"] = pd.Series([auroc]*len(df_small), index = df_small.index)
		df_small["auprc"] = pd.Series([auprc]*len(df_small), index = df_small.index)
		df_small['num_pos'] = pd.Series([positives_length]*len(df_small), index = df_small.index)
		df_small['num_neg_used'] = pd.Series([active_negatives_length]*len(df_small), index = df_small.index)
		df_small['num_neg_real'] = pd.Series([real_negatives_length]*len(df_small), index = df_small.index)
		df_small['real_balance'] = pd.Series([real_balance]*len(df_small), index = df_small.index)
		df_small['active_balance'] = pd.Series([active_balance]*len(df_small), index = df_small.index)
		return df_small
